import geopandas as gpd
from shapely.geometry import Point, LineString
import sys
import os
import logging

script_path = os.path.dirname(os.path.realpath(__file__))

# sys.argv.append(r'c:\ProgramData\AtlasLtd\AtlasDMT\DMRCuzk\mapovelisty.gpkg')
# sys.argv.append(r'c:\ProgramData\AtlasLtd\AtlasDMT\DMRCuzk\downloadKuPol.csv')

fromfile = False
if "csv" in sys.argv[-1]:
    fromfile = True
    gpkgpath = sys.argv[-2]
    polPath = sys.argv[-1]
    
else:
    try:
        gpkgpath = sys.argv[1]
        x = float(sys.argv[2])
        y = float(sys.argv[3])
    except:
        gpkgpath = r'c:\ProgramData\AtlasLtd\AtlasDMT\DMRCuzk\mapovelisty.gpkg'
        x = -721663.160
        y = -1009443.060

        # x = -736880.910
        # y = -1038896.270
    #
        logging.basicConfig(filename='getKU.log', level=logging.DEBUG,
                            format='%(asctime)s - %(name)s - %(levelname)s - %(message)s')

def GetKU():
    # Nahrání GeoPackage do GeoDataFrame
    gdf = gpd.read_file(gpkgpath, layer='spravnijednotky', encoding='utf-8')

    # Vytvoření bodu pomocí Shapely
    point = Point(x, y)

    # Vytvoření sloupce s indexy polygonů, ve kterých leží bod
    gdf['contains_point'] = gdf['geometry'].contains(point)

    # Získání indexu polygonu, ve kterém leží bod
    index_of_containing_polygon = gdf[gdf['contains_point'] == True].index

    # # Výpis výsledku
    if not index_of_containing_polygon.empty:
        s = "{};{};{}".format("ok", gdf.iloc[index_of_containing_polygon.values[0]]['KODKU'], gdf.iloc[index_of_containing_polygon.values[0]]['NAZEVKU'])
        print(s)
        # f = open(script_path + "\\kodku.txt", 'w')
        # f.write(s)
        # f.close()


def LoadPolFromFile():

    f = open(polPath, "r")

    line = []
    if not f.closed:
        lines = f.readlines()

        for l in lines:
            xy = l.split()
            point = (-float(xy[1]), -float(xy[0]))
            line.append(point)


    lineframe = gpd.GeoDataFrame({'geometry': [LineString(line)]})
    lineframe.crs = '5514'

    return lineframe




def GetKUPol():
    # Nahrání GeoPackage do GeoDataFrame
    gdf = gpd.read_file(gpkgpath, layer='spravnijednotky', encoding='utf-8')


    line_gdf = LoadPolFromFile()

    # # Vytvoření sloupce s indexy polygonů, ve kterých leží bod
    # gdf['contains_point'] = gdf['geometry'].contains(point)

    # Provedení prostorového spojení
    joined_gdf = gpd.sjoin(gdf, line_gdf, how='inner', op='intersects')
    # joined_gdf = gdf.intersects(line_gdf)


    s = ""
    for index, row in joined_gdf.iterrows():
        s += "{};{};{}!".format("ok", row["KODKU"], row["NAZEVKU"])

    print(s[:-1])
    # # # Výpis výsledku
    # if not index_of_containing_polygon.empty:
    #     s = "{};{};{}".format("ok", gdf.iloc[index_of_containing_polygon.values[0]]['KODKU'], gdf.iloc[index_of_containing_polygon.values[0]]['NAZEVKU'])
    #     print(s)
    #     # f = open(script_path + "\\kodku.txt", 'w')
    #     # f.write(s)
    #     # f.close()

if __name__ == "__main__":


    # mapListSm05()
    try:

        if fromfile:
            GetKUPol()
        else:
            GetKU()
        #
    except Exception as e:
        ef = open(script_path+'/except', 'w')
        ef.write(str(e))
        ef.close()